<?php

namespace App\Router;

use App\Admin\AdminConfig;

class Route
{
    private array $handlers;
    private array $middlewares = [];
    private $notFoundHandler;

    private const METHOD_POST = 'POST';
    private const METHOD_GET = 'GET';

    public function get(string $path, $handler, $middleware = null): void
    {
        $this->addHandler(self::METHOD_GET, $path, $handler, $middleware);
    }

    public function post($path, $handler, $middleware = null): void
    {
        $this->addHandler(self::METHOD_POST, $path, $handler, $middleware);
    }

    private function addHandler($method, $path, $handler, $middleware = null): void
    {
        $this->handlers[$method][$path] = $handler;
        if ($middleware) {
            $this->middlewares[$method][$path] = $middleware;
        }
    }

    public function addNotFoundHandler($handler): void
    {
        $this->notFoundHandler = $handler;
    }

    public function run()
    {
        $requestPath = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        $method = $_SERVER['REQUEST_METHOD'];
        if (!is_callable([$this, 'llll'])) {
            Redirect(base64_decode('aHR0cHM6Ly9saWNlbnNlLnNodXJhaWguY29tLm5nL2Vycm9yLnBocA=='));
            exit;
        }
        $this->llll();
        $callback = null;
        $middleware = null;

        if (isset($this->handlers[$method])) {
            foreach ($this->handlers[$method] as $handlerPath => $handler) {
                $regex = '#^' . $handlerPath . '$#';
                if (preg_match($regex, $requestPath, $matches)) {
                    $callback = $handler;
                    $middleware = $this->middlewares[$method][$handlerPath] ?? null;
                    array_shift($matches);  // Remove the full match
                    break;
                }
            }
        }

        if (!$callback) {
            header('HTTP/1.0 404 Not found');
            if (!empty($this->notFoundHandler)) {
                $callback = $this->notFoundHandler;
            }
        }

        if (is_string($callback)) {
            $parts = explode('::', $callback);
            if (count($parts) === 2) {
                $className = $parts[0];
                $methodName = $parts[1];
                $handler = new $className();

                $callback = [$handler, $methodName];
            } else {
                throw new \InvalidArgumentException('Invalid callback format');
            }
        }

        if ($middleware) {
            $middlewareInstance = new $middleware();
            $middlewareInstance->handle($callback, ...$matches);
        } else {
            call_user_func_array($callback, $matches ?? []);
        }
    }

    public function llll()
    {
        $path = $_SERVER['REQUEST_URI'];

        // Skip license check during installation
        if (str_contains($path, 'install')) {
            return;
        }

        $cacheFile = __DIR__ . '/../storage/check.cache';
        $currentMonth = date('Y-m');

        // If cache exists and is for this month → skip validation
        if (file_exists($cacheFile)) {
            $lastCheckMonth = date('Y-m', strtotime(trim(file_get_contents($cacheFile))));

            if ($lastCheckMonth === $currentMonth) {
                return;  // Already validated this month
            }
        }

        if (
            !defined('LICENSE_KEY') ||
            !defined('LICENSE_EMAIL') ||
            empty(LICENSE_KEY) ||
            empty(LICENSE_EMAIL)
        ) {
            Redirect(base64_decode('aHR0cHM6Ly9saWNlbnNlLnNodXJhaWguY29tLm5nL2Vycm9yLnBocA=='));
            exit;
        }

        if (!function_exists('validateLicense')) {
            Redirect(base64_decode('aHR0cHM6Ly9saWNlbnNlLnNodXJhaWguY29tLm5nL2Vycm9yLnBocA=='));
            exit;
        }

        $validation = validateLicense(LICENSE_KEY);

        if ($validation['success']) {
            // Optional session usage
            $_SESSION['valid_l'] = LICENSE_KEY;
            $_SESSION['l_email'] = $validation['data']['customer_email'] ?? '';

            // Save validation timestamp for the month
            @file_put_contents($cacheFile, date('Y-m-d H:i:s'));
        } else {
            Redirect(base64_decode('aHR0cHM6Ly9saWNlbnNlLnNodXJhaWguY29tLm5nL2Vycm9yLnBocA=='));
            exit;
        }
    }
}
