<?php
namespace App\General\Admin;

use Google\Client;
use Google\Service\AnalyticsData;

class Analytics 
{
    private $analyticsData;

    public function __construct() 
    {
        $keyFilePath = __DIR__.'/../../../config/analytic-secret.json';
        
        $client = new Client();
        $client->setAuthConfig($keyFilePath);
        $client->addScope('https://www.googleapis.com/auth/analytics.readonly');
        
        // Initialize Analytics Data service
        $this->analyticsData = new AnalyticsData($client);
    }
    
    public function getData($propertyId, $startDate = 'today', $endDate = 'today')
    {
        
$request = new AnalyticsData\RunReportRequest([
        'dimensions' => [
            new AnalyticsData\Dimension(['name' => 'date']),
            new AnalyticsData\Dimension(['name' => 'country']), // Example: active users by country
        ],
        'metrics' => [
            new AnalyticsData\Metric(['name' => 'activeUsers']),
            new AnalyticsData\Metric(['name' => 'sessions']),
            new AnalyticsData\Metric(['name' => 'screenPageViews']), // Valid metric for views
        ],
        'dateRanges' => [
            new AnalyticsData\DateRange(['startDate' => $startDate, 'endDate' => $endDate]),
        ],
    ]);

    // Run the report
    return $this->analyticsData->properties->runReport("properties/$propertyId", $request);
    }
    
      public function getViewsByCountry($propertyId, $startDate = 'today', $endDate = 'today')
    {
        $request = new AnalyticsData\RunReportRequest([
            'dimensions' => [
                new AnalyticsData\Dimension(['name' => 'country']), // Country dimension
            ],
            'metrics' => [
                new AnalyticsData\Metric(['name' => 'screenPageViews']), // Views metric
            ],
            'dateRanges' => [
                new AnalyticsData\DateRange(['startDate' => $startDate, 'endDate' => $endDate]),
            ],
        ]);

        $response = $this->analyticsData->properties->runReport("properties/$propertyId", $request);

        $viewsByCountry = [];
        foreach ($response->getRows() as $row) {
            $country = $row->getDimensionValues()[0]->getValue();
            $views = $row->getMetricValues()[0]->getValue();

            $viewsByCountry[] = [
                'country' => $country,
                'views' => $views,
            ];
        }

        return $viewsByCountry;
    }

    // Views by Page
    public function getViewsByPage($propertyId, $startDate = 'today', $endDate = 'today')
    {
        $request = new AnalyticsData\RunReportRequest([
            'dimensions' => [
                new AnalyticsData\Dimension(['name' => 'pageTitle']), // Page Title dimension
            ],
            'metrics' => [
                new AnalyticsData\Metric(['name' => 'screenPageViews']), // Views metric
            ],
            'dateRanges' => [
                new AnalyticsData\DateRange(['startDate' => $startDate, 'endDate' => $endDate]),
            ],
        ]);

        $response = $this->analyticsData->properties->runReport("properties/$propertyId", $request);

        $viewsByPage = [];
        foreach ($response->getRows() as $row) {
            $pageTitle = $row->getDimensionValues()[0]->getValue();
            $views = $row->getMetricValues()[0]->getValue();

            $viewsByPage[] = [
                'pageTitle' => $pageTitle,
                'views' => $views,
            ];
        }

        return $viewsByPage;
    }
}
