<?php require_once __DIR__.'/get.php'; ?>
<div class="my-3 d-flex justify-content-between align-items-center">
    <h2>Google Analytics</h2>
    <a href="<?php echo $pluginURL.'&route=all'?>" class="btn btn-primary">View more Stats</a>
</div>

  
<div class="row"> 
<?php if($set === true) : ?>
           <div class="col-sm-6 col-lg-3 mb-3">
            <div class="card card-border-shadow-primary h-100">
              <div class="card-body">
                <div class="d-flex align-items-center mb-2">
                  <div class="avatar me-4">
                    <span class="avatar-initial rounded bg-label-primary"><i class="mdi mdi-signal mdi-24px"></i></span>
                  </div>
                  <h4 id='views-count' class="mb-0"><?php echo number_format($overview['pageviews']); ?></h4>
                </div>
                <h6 class="mb-0 fw-normal">Views </h6>
                <p class="mb-0">
                  <small class="text-muted">Total Views</small>
                </p>
              </div>
            </div>
          </div>
          
            <div class="col-sm-6 col-lg-3 mb-3">
            <div class="card card-border-shadow-warning h-100">
              <div class="card-body">
                <div class="d-flex align-items-center mb-2">
                  <div class="avatar me-4">
                    <span class="avatar-initial rounded bg-label-warning"><i class="mdi mdi-face-man-profile mdi-24px"></i></span>
                  </div>
                  <h4 class="mb-0" id="active-users-count"><?php echo number_format($overview['users']); ?></h4>
                </div>
                <h6 class="mb-0 fw-normal">Active users</h6>
                <p class="mb-0">
                 
                  <small class="text-muted">Total Active Users</small>
                </p>
              </div>
            </div>
          </div>
          
            <div class="col-sm-6 col-lg-3 mb-3">
            <div class="card card-border-shadow-danger h-100">
              <div class="card-body">
                <div class="d-flex align-items-center mb-2">
                  <div class="avatar me-4">
                    <span class="avatar-initial rounded bg-label-danger"><i class="mdi mdi-signal-5g mdi-24px"></i></span>
                  </div>
                  <h4 class="mb-0" id="sessions-count"><?php echo number_format($overview['sessions']); ?></h4>
                </div>
                <h6 class="mb-0 fw-normal">Sessions</h6>
                <p class="mb-0">
                  <small class="text-muted">Total Sessions</small>
                </p>
              </div>
            </div>
          </div>
          
            <div class="col-sm-6 col-lg-3 mb-3">
            <div class="card card-border-shadow-danger h-100">
              <div class="card-body">
                <div class="d-flex align-items-center mb-2">
                  <div class="avatar me-4">
                    <span class="avatar-initial rounded bg-label-secondary"><i class="mdi mdi-av-timer mdi-24px"></i></span>
                  </div>
                  <?php
                    $duration = (int) round($overview['avgSessionDuration']);
                    $minutes = floor($duration / 60);
                    $seconds = $duration % 60;
                    ?>
                    <h4 class="mb-0" id="sessions-count"><?php echo $minutes . 'm ' . $seconds . 's'; ?></h4>
                </div>
                <h6 class="mb-0 fw-normal">Duration</h6>
                <p class="mb-0">
                  <small class="text-muted">Avg. Session Duration</small>
                </p>
              </div>
            </div>
          </div>
  
            <div class="col-xl-12 mb-5">
    <div class="card h-100">
      <div class="card-body row g-2">
        <div class="col-12 col-md-6 card-separator pe-0 pe-md-3">
          <div class="d-flex justify-content-between align-items-center flex-wrap mb-4">
            <h5 class="m-0 me-2">Views by Country</h5>
          </div>
          <div class="pt-2">
            <div id="countries-count" class="list-group list-group-flush">
              <?php foreach($countries as $row) :?>
              <div class="list-group-item list-group-item-action waves-effect"><?php echo $row['country']?>: <?php echo $row['users']?></div>
              <?php endforeach; ?>
            </div>
            
          </div>
        </div>
        
        
        <div class="col-12 col-md-6 ps-0 ps-md-3 mt-3 mt-md-2">
          <div class="d-flex justify-content-between align-items-center flex-wrap mb-4">
            <h5 class="m-0 me-2">Views by Pages</h5>
          </div>
          <div class="pt-2">
            <div class="list-group list-group-flush" id="pages-list-views">
                  <?php foreach($pageViews as $row) :?>
              <div class="list-group-item list-group-item-action waves-effect"><?php echo $row['pageTitle']?>: <?php echo $row['pageviews']?></div>
              <?php endforeach; ?>
            </ul>
          </div>
        </div>
      </div>
      
    </div>
  </div>
  </div>
<?php else: ?>
    <div class="col-xl-12">
    <div class="card mb-5">
    <div class="card-body row g-2">
        <p>You did not set your Google Analytics</p>
        <a href="<?php echo $pluginURL.'&route=connect'?>">Pls set it here</a>
    </div>
</div>
    </div>


<?php endif; ?>

  </div>