 <style>
.container {
    max-width: 800px;
    margin: 50px auto;
    padding: 30px;
    background-color: #fff;
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    text-align: center;
}

/* Dashboard Styles */
.dashboard-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 20px;
}

.dashboard-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    background: white;
    padding: 15px;
    border-radius: 5px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.property-info {
    display: flex;
    flex-direction: column;
}

.property-name {
    font-size: 18px;
    font-weight: bold;
}

.property-details {
    display: flex;
    gap: 10px;
    margin-top: 5px;
}

.property-badge {
    display: inline-block;
    background: #007bff;
    color: white;
    padding: 2px 8px;
    border-radius: 3px;
    font-size: 12px;
}

.measurement-id {
    background: #28a745;
}

.date-filter {
    display: flex;
    align-items: center;
    gap: 10px;
}

.date-filter input {
    padding: 8px;
    border: 1px solid #ddd;
    border-radius: 4px;
}

.button {
    background: #007bff;
    color: white;
    border: none;
    padding: 8px 15px;
    border-radius: 4px;
    cursor: pointer;
}

.metrics-overview {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 15px;
    margin-bottom: 20px;
}

.metric-card {
    background: white;
    padding: 15px;
    border-radius: 5px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    text-align: center;
}

.metric-value {
    font-size: 24px;
    font-weight: bold;
    color: #007bff;
}

/* FIXED CHART STYLES - This is the key fix */
.charts-container {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(500px, 1fr));
    gap: 20px;
}

.chart-card {
    background: white;
    padding: 20px;
    border-radius: 5px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    margin-bottom: 20px;
    /* IMPORTANT: Set explicit dimensions */
    min-height: 400px;
    position: relative;
}

.chart-card h3 {
    margin-top: 0;
    margin-bottom: 20px;
    color: #333;
}

/* CRITICAL: Fixed chart canvas container */
.chart-container {
    position: relative;
    height: 300px; /* Fixed height */
    width: 100%;
    margin: 20px 0;
}



/* Table Styles */
.data-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 20px;
}

.data-table th, .data-table td {
    padding: 10px;
    text-align: left;
    border-bottom: 1px solid #eee;
}

.data-table th {
    background: #f8f9fa;
}

.error-message {
    background: #f8d7da;
    color: #721c24;
    padding: 15px;
    border-radius: 5px;
    margin-bottom: 20px;
    border: 1px solid #f5c6cb;
}

.code-block {
    background: #f8f9fa;
    border: 1px solid #eee;
    border-radius: 5px;
    padding: 15px;
    margin: 15px 0;
    font-family: monospace;
    white-space: pre-wrap;
}

.integration-info {
    background: #e7f3ff;
    border: 1px solid #b8daff;
    border-radius: 5px;
    padding: 15px;
    margin: 20px 0;
}

/* Responsive Adjustments */
@media (max-width: 768px) {
    .charts-container {
        grid-template-columns: 1fr;
    }
    
    .dashboard-header {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .date-filter {
        margin-top: 15px;
        width: 100%;
    }
    
    .chart-container {
        height: 250px; /* Smaller height on mobile */
    }
}
    </style>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="dashboard-header">
            <div class="property-info">
                <span class="property-name"><?php echo htmlspecialchars($credentials['property_name']); ?></span>
                <div class="property-details">
                    <span class="property-badge"><?php echo htmlspecialchars($credentials['property_type']); ?></span>
                    <?php if (!empty($credentials['measurement_id'])): ?>
                        <span class="property-badge measurement-id">Measurement ID: <?php echo htmlspecialchars($credentials['measurement_id']); ?></span>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="date-filter">
                <form method="get" action="">
                                        <input type="hidden" name="plugin" value="google-analytics" />
                    <input type="hidden" name="route" value="dashboard" />
                    <label for="start_date">From:</label>
                    <input type="date" id="start_date" name="start_date" value="<?php echo $start_date; ?>">
                    
                    <label for="end_date">To:</label>
                    <input type="date" id="end_date" name="end_date" value="<?php echo $end_date; ?>">
                    
                    <button type="submit" class="button">Apply</button>
                </form>
            </div>
        </div>
        
        <?php if (isset($error)): ?>
            <div class="error-message">
                <?php echo htmlspecialchars($error); ?>
                <a href="<?php echo $pluginURL?>&route=connect" class="btn btn-primary" style="margin-left: 10px;">Reconnect</a>
            </div>
        <?php endif; ?>
        <div class="row mt-5">
           <div class="col-sm-6 col-lg-3 mb-3">
            <div class="card card-border-shadow-primary h-100">
              <div class="card-body">
                <div class="d-flex align-items-center mb-2">
                  <div class="avatar me-4">
                    <span class="avatar-initial rounded bg-label-primary"><i class="mdi mdi-signal mdi-24px"></i></span>
                  </div>
                  <h4 id='views-count' class="mb-0"><?php echo number_format($overview['pageviews']); ?></h4>
                </div>
                <h6 class="mb-0 fw-normal">Views </h6>
                <p class="mb-0">
                  <small class="text-muted">Total Views</small>
                </p>
              </div>
            </div>
          </div>
          
            <div class="col-sm-6 col-lg-3 mb-3">
            <div class="card card-border-shadow-warning h-100">
              <div class="card-body">
                <div class="d-flex align-items-center mb-2">
                  <div class="avatar me-4">
                    <span class="avatar-initial rounded bg-label-warning"><i class="mdi mdi-face-man-profile mdi-24px"></i></span>
                  </div>
                  <h4 class="mb-0" id="active-users-count"><?php echo number_format($overview['users']); ?></h4>
                </div>
                <h6 class="mb-0 fw-normal">Active users</h6>
                <p class="mb-0">
                 
                  <small class="text-muted">Total Active Users</small>
                </p>
              </div>
            </div>
          </div>
          
            <div class="col-sm-6 col-lg-3 mb-3">
            <div class="card card-border-shadow-danger h-100">
              <div class="card-body">
                <div class="d-flex align-items-center mb-2">
                  <div class="avatar me-4">
                    <span class="avatar-initial rounded bg-label-danger"><i class="mdi mdi-signal-5g mdi-24px"></i></span>
                  </div>
                  <h4 class="mb-0" id="sessions-count"><?php echo number_format($overview['sessions']); ?></h4>
                </div>
                <h6 class="mb-0 fw-normal">Sessions</h6>
                <p class="mb-0">
                  <small class="text-muted">Total Sessions</small>
                </p>
              </div>
            </div>
          </div>
          
            <div class="col-sm-6 col-lg-3 mb-3">
            <div class="card card-border-shadow-danger h-100">
              <div class="card-body">
                <div class="d-flex align-items-center mb-2">
                  <div class="avatar me-4">
                    <span class="avatar-initial rounded bg-label-secondary"><i class="mdi mdi-av-timer mdi-24px"></i></span>
                  </div>
                  <?php
                    $duration = (int) round($overview['avgSessionDuration']);
                    $minutes = floor($duration / 60);
                    $seconds = $duration % 60;
                    ?>
                    <h4 class="mb-0" id="sessions-count"><?php echo $minutes . 'm ' . $seconds . 's'; ?></h4>
                </div>
                <h6 class="mb-0 fw-normal">Duration</h6>
                <p class="mb-0">
                  <small class="text-muted">Avg. Session Duration</small>
                </p>
              </div>
            </div>
          </div>
        </div>
        
        <div class="row mt-5">
            <div class="chart-card">
                
                
            <div class="my-3 d-flex justify-content-between align-items-center">
                <h3>Top Pages</h3>
                <a href="<?php echo $pluginURL?>&route=all" class="btn btn-primary">View All Statistics</a>
            </div>

                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Page</th>
                            <th>Views</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($pageViews as $page): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($page['pagePath']); ?></td>
                                <td><?php echo number_format($page['pageviews']); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                
                <div>
                    
                </div>
            </div>
        </div>
        
        
        <div class="row chart-card">
            <div class="col-sm-6">

                <div class="chart-container card-body">
                    <h3>Traffic Over Time</h3>
                    <canvas id="trafficChart"></canvas>
                </div>

            </div>
                        
                        
            <div class="col-sm-6">
   
                <div class="chart-container card-body">
                    <h3>Top Countries</h3>
                    <canvas id="countriesChart"></canvas>
                </div>
            </div>
        </div>
        

        
    </div>
    
    <script>
        // Traffic over time chart
        const trafficData = <?php echo json_encode($dailyTraffic); ?>;
        
        new Chart(document.getElementById('trafficChart'), {
            type: 'line',
            data: {
                labels: trafficData.map(item => item.date),
                datasets: [{
                    label: 'Users',
                    data: trafficData.map(item => item.users),
                    borderColor: '#4285F4',
                    backgroundColor: 'rgba(66, 133, 244, 0.1)',
                    fill: true
                }, {
                    label: 'Sessions',
                    data: trafficData.map(item => item.sessions),
                    borderColor: '#34A853',
                    backgroundColor: 'rgba(52, 168, 83, 0.1)',
                    fill: true
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    x: {
                        grid: {
                            display: false
                        }
                    }
                }
            }
        });
        
        // Countries chart
        const countryData = <?php echo json_encode($countries); ?>;
        
        new Chart(document.getElementById('countriesChart'), {
            type: 'pie',
            data: {
                labels: countryData.map(item => item.country),
                datasets: [{
                    data: countryData.map(item => item.users),
                    backgroundColor: [
                        '#4285F4', '#EA4335', '#FBBC05', '#34A853', '#FF6D01',
                        '#46BDC6', '#9C27B0', '#2196F3', '#F44336', '#FFEB3B'
                    ]
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false
            }
        });
    </script>
