<?php
global $db;
// Check if user is authenticated
if (!isset($_SESSION['ga_access_token'])) {
    Redirect($pluginURL.'&route=connect');
    exit;
}

$properties = $_SESSION['ga_properties'] ?? [];

// Handle property selection
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['property_id'])) {
    try {
        $property_id = $_POST['property_id'];
        $property_name = $_POST['property_name'];
        $account_id = $_POST['account_id'];
        $account_name = $_POST['account_name'];
        
        // Create Google Client to get measurement ID
        $client = createGoogleClient();
        $client->setAccessToken($_SESSION['ga_full_token']);
        
        $analyticsAdmin = new Google_Service_GoogleAnalyticsAdmin($client);
        $measurement_id = '';
        
        try {
            // Get data streams to find measurement ID
            $dataStreams = $analyticsAdmin->properties_dataStreams->listPropertiesDataStreams(
                'properties/' . $property_id
            );
            
            // Look for a web data stream to get measurement ID
            foreach ($dataStreams->getDataStreams() as $dataStream) {
                if ($dataStream->getType() === 'WEB_DATA_STREAM') {
                    $measurement_id = $dataStream->getWebStreamData()->getMeasurementId();
                    break;
                }
            }
        } catch (Exception $e) {
            error_log('Error fetching measurement ID: ' . $e->getMessage());
            // Continue without measurement ID if there's an error
        }
        
        // Store the selected property in the database
        $user_id = $_SESSION['adminID'] ?? 1; // Assuming user is logged in
        $access_token = $_SESSION['ga_access_token'];
        $refresh_token = $_SESSION['ga_refresh_token'] ?? '';
        $token_expires = $_SESSION['ga_token_expires'];
        $full_token = json_encode($_SESSION['ga_full_token']);
        
        $_SESSION['ga_no_property'] = $property_id;
        
        $admin_id = $_SESSION['adminID'] ?? 1;
        
        $db->table('google_analytics_credentials')->update([
            'status' => 0]);
            
        $db->raw("
        INSERT INTO google_analytics_credentials 
        (admin_id, access_token, refresh_token, property_id, property_name, property_type, 
         account_id, account_name, measurement_id, token_expires, full_token, status) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ON DUPLICATE KEY UPDATE 
        access_token = VALUES(access_token),
        refresh_token = VALUES(refresh_token),
        property_id = VALUES(property_id),
        property_name = VALUES(property_name),
        property_type = VALUES(property_type),
        account_id = VALUES(account_id),
        account_name = VALUES(account_name),
        measurement_id = VALUES(measurement_id),
        token_expires = VALUES(token_expires),
        full_token = VALUES(full_token),
        status = VALUES(status)
    ", [
        $admin_id,
        $access_token,
        $refresh_token,
        $property_id,
        $property_name,
        'GA4',
        $account_id,
        $account_name,
        $measurement_id,
        $token_expires,
        $full_token,
        1
    ]);
    
    $success = $db->run();
    
    if($success) {
        
        Redirect($pluginURL.'&route=dashboard');
    }
        
    } catch (Exception $e) {
        $error = "Error: " . $e->getMessage();
    }
}


require_once($headerT);
require_once $pvt.'/select_property.php';
require_once($footerT);
?>