<?php
global $db;
$user_id = $_SESSION['adminID'] ?? 1;

// Get Google Analytics credentials from database

$credentials = $db->table('google_analytics_credentials')->where('status', 1)->first();


if (!$credentials) {
    Redirect($pluginURL.'&route=connect');
    exit;
}

// Set date range (default: last 30 days)
$end_date = date('Y-m-d');
$start_date = date('Y-m-d', strtotime('-30 days'));

if (isset($_GET['start_date']) && isset($_GET['end_date'])) {
    $start_date = $_GET['start_date'];
    $end_date = $_GET['end_date'];
}

try {
    // Create analytics service
    $analyticsService = new GoogleAnalyticsService($credentials);
    
    // Get analytics data
    $overview = $analyticsService->getOverviewMetrics($start_date, $end_date);
    $pageViews = $analyticsService->getPageViews($start_date, $end_date);
    $countries = $analyticsService->getUserCountries($start_date, $end_date);
    $dailyTraffic = $analyticsService->getDailyTraffic($start_date, $end_date);
    
} catch (Exception $e) {
    $error = "Error loading analytics data: " . $e->getMessage();
    error_log($error);
    
    // Set default empty data
    $overview = ['users' => 0, 'sessions' => 0, 'pageviews' => 0, 'avgSessionDuration' => 0];
    $pageViews = [];
    $countries = [];
    $dailyTraffic = [];
}

require_once($headerT);
require_once $pvt.'/dashboard.php';
require_once($footerT);
?>