<?php
global $db;
require_once __DIR__.'/config.php';
define('GOOGLE_REDIRECT_URI', APP_URL.AdminURL.'/oauth-callback?analytics');
$pluginURL = APP_URL.AdminURL.'/setting?plugin=google-analytics';

// Google Analytics scopes
define('GOOGLE_ANALYTICS_SCOPES', [
    'https://www.googleapis.com/auth/analytics.readonly',
    'https://www.googleapis.com/auth/analytics.manage.users.readonly'
]);

// Function to verify API requests using secret key
function verifyApiRequest() {
    $headers = getallheaders();
    
    if (!isset($headers['X-Api-Key']) || $headers['X-Api-Key'] !== API_SECRET_KEY) {
        header('HTTP/1.1 401 Unauthorized');
        echo json_encode(['error' => 'Unauthorized access']);
        exit;
    }
    
    return true;
}

// Function to create Google Client
function createGoogleClient() {
    $client = new Google_Client();
    $client->setClientId(GOOGLE_CLIENT_ID);
    $client->setClientSecret(GOOGLE_CLIENT_SECRET);
    $client->setRedirectUri(GOOGLE_REDIRECT_URI);
    $client->setScopes(GOOGLE_ANALYTICS_SCOPES);
    $client->setAccessType('offline');
    $client->setPrompt('consent');
    
    return $client;
}

require_once __DIR__.'/../controllers/Api/google_analytics_api.php';

$headerT = __DIR__.'/../views/header.php';
$footerT = __DIR__.'/../views/footer.php';

$title = "Google analytics";

$pct = __DIR__.'/../controllers';
$pvt = __DIR__.'/../views';


