	<!-- details -->
	<style>
		.comments__text p,
		p {
			color: #fff;
		}
	</style>
	<section class="section section--details">
		<!-- details content -->
		<div class="container">
			<div class="row">
				<!-- title -->
				<div class="col-12" id="file">
					<h1 class="section__title section__title--head"><?php echo $file['name']; ?></h1>
				</div>
				<!-- end title -->

				<!-- content -->
				<div class="col-12 col-md-8">

					<div class="item item--details">
						<div class="row">
							<!-- card cover -->
							<div class="col-12 col-sm-5 col-md-5 col-lg-4 col-xl-6 col-xxl-5">
								<div class="item__cover d-flex justify-content-center align-items-center">
									<img src="<?php echo $ogImage; ?>" alt="<?php echo $file['name']; ?>">
								</div>
							</div>
							<!-- end card cover -->

							<!-- card content -->
							<div class="col-12 col-sm-7 col-md-7 col-lg-8 col-xl-6 col-xxl-7">
								<div class="item__content">
									<ul class="item__meta">
										<li><span>Author:</span> <?php echo $file['author'] ? $author : 'None'; ?></li>
										<li><span>Category:</span> <?php echo $file['cat_slug'] ? '<a href="' . APP_URL . '/category/' . $file['cat_slug'] . '">' . $file['cat_name'] . '</a>' : 'None'; ?></li>
										<li><span>Compiler:</span> <?php echo (isset($compiler) ?  $compiler : 'None'); ?></li>
										<li><span>Association:</span> <?php echo (isset($group) ?  $group : 'None'); ?></li>
										<li><span>Book Series:</span> <?php echo (isset($book) ? $book : 'None'); ?></li>
										<li><span>Upload Date:</span> <?php echo date('d D m, Y', strtotime($file['created_at'])); ?></li>
										<li><span>File Size:</span> <?php echo formatSize($file['size']); ?></li>
										<li><span>Total Views:</span> <?php echo $file['views']; ?></li>
										<li><span>File Downloads:</span> <?php echo $file['download']; ?></li>
										<li><span>Last Download:</span> <?php echo !empty('dl_last') ? to_time_ago(strtotime($file['dl_last'] ?? '')) : 'N/A'; ?></li>
									</ul>
									<?php include 'includes/views/read_download_button.php'; ?>
								</div>
							</div>
							<!-- end card content -->
						</div>
					</div>

					<div class="row mt-5">
						<div class="col-12">
							<!-- content title -->
							<h2 class="content__title">Discover</h2>
							<!-- content tabs nav -->
							<ul class="nav nav-tabs content__tabs" id="content__tabs" role="tablist">
								<li class="nav-item" role="presentation">
									<button id="1-tab" class="active" data-bs-toggle="tab" data-bs-target="#tab-1" type="button" role="tab" aria-controls="tab-1" aria-selected="true">Description</button>
								</li>

								<li class="nav-item" role="presentation">
									<button id="2-tab" data-bs-toggle="tab" data-bs-target="#tab-2" type="button" role="tab" aria-controls="tab-2" aria-selected="false"><?php echo $total_reviews; ?> Comments</button>
								</li>

								<li class="nav-item" role="presentation">
									<button id="3-tab" data-bs-toggle="tab" data-bs-target="#tab-3" type="button" role="tab" aria-controls="tab-3" aria-selected="false">Related by Author</button>
								</li>
							</ul>
							<!-- end content tabs nav -->

							<!-- content tabs -->
							<div class="tab-content">
								<div class="tab-pane fade show active" id="tab-1" role="tabpanel" aria-labelledby="1-tab" tabindex="0">
									<div class="row">
										<!-- comments -->
										<div class="col-12">
											<div class="comments">
												<ul class="comments__list">
													<li class="comments__item">
														<p class="comments__text" style="color:#fff;"> <?php echo htmlspecialchars_decode($file['description']); ?> </p>
													
													</li>
												</ul>
											</div>
										</div>
										<!-- end comments -->
									</div>
								</div>

								<div class="tab-pane fade" id="tab-2" role="tabpanel" aria-labelledby="2-tab" tabindex="0">
									<div class="row">
										<!-- reviews -->
										<div class="col-12">
											<?php include 'includes/views/reviews.php'; ?>
										</div>
										<!-- end reviews -->
									</div>
								</div>

								<div class="tab-pane fade" id="tab-3" role="tabpanel" aria-labelledby="3-tab" tabindex="0">
									<div class="row">
										<!-- reviews -->
										<div class="col-12">
											<?php include 'includes/views/author_related.php'; ?>
										</div>
										<!-- end reviews -->
									</div>
								</div>
							</div>
							<!-- end content tabs -->
						</div>
					</div>
				</div>
				<!-- end content -->

				<!-- player -->
				<div class="col-12 col-md-4">
					<h2 class="content__title">Novels You may like</h2>
					<?php foreach ($rand as $file) : ?>
						<?php

						$image = empty($file['image']) ? APP_URL . '/Public/main/noimage2.jpg' : APP_URL . '/Public/thumb/225x325' . $file['img_folder'] . '/' . $file['image'];

						?>
						<div class="popular-item mb-3">
							<img src="<?php echo $image; ?>" class="popular-image" alt="<?php echo $file['name']; ?>">
							<div>
								<a href="<?php echo APP_URL . '/' . $file['slug']; ?>" class="popular-title"><?php echo $file['name']; ?></a>
								<p class="popular-author"><?php $authors = explode(',', $file['author']);
															foreach ($authors as $author) {
																$aut = $db->table('author')->search(['name'], $author)->first();
																echo '<a href="' . APP_URL . '/author/' . $aut['slug'] . '">' . $author . '</a> ,';
															}
															?></p>
								<p class="popular-meta">Views: <?php echo formatNumberShort($file['views']); ?> | <?php echo date('d M, Y', strtotime($file['created_at'])); ?></p>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
				<!-- end player -->
			</div>
		</div>
		<!-- end details content -->
	</section>
	<!-- end details -->


	<!-- related ebooks -->
	<?php include 'includes/views/related_ebooks.php'; ?>
	<!-- end related ebooks -->