<div class="comments">
    <ul class="comments__list">

        <?php

        $nestedReviews = [];
        $lookup = [];

        // Initialize lookup and base structure
        foreach ($reviews as $review) {
            $review['replies'] = [];
            $lookup[$review['id']] = $review;
        }


        // Build the nested structure
        foreach ($reviews as $review) {
            if ($review['parent_id'] == 0) {
                $nestedReviews[] = &$lookup[$review['id']];
            } else {
                if (isset($lookup[$review['parent_id']])) {
                    $lookup[$review['parent_id']]['replies'][] = &$lookup[$review['id']];
                }
            }
        }
        echo renderReviews($nestedReviews, $isLogin, $file, $AuthUser)

        ?>
    </ul>
    <!-- end paginator desktop -->
    <?php if (!$isLogin) : ?>
        <div class="sign__login">
            <h3 class="sign__title">Please login to add a comment</h3>
            <a href="<?= APP_URL ?>/login" class="sign__btn sign__btn--primary">Login</a>
        </div>
    <?php else: ?>
        <form action="#" class="sign__form sign__form--comments auth">
            <input type="hidden" name="user_id" value="<?php echo $AuthUser['id']; ?>">
            <input type="hidden" name="file_id" value="<?php echo $file['id']; ?>">
            <input type="hidden" name="action" value="addreview">
            <div class="sign__group">
                <textarea name="content" class="sign__textarea" placeholder="Add comment"></textarea>
            </div>

            <button type="submit" class="sign__btn sign__btn--small">Send</button>
        </form>
    <?php endif; ?>

</div>