<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title><?php echo APP_NAME; ?> - Forgot Password</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
    <link rel="stylesheet" href="<?= ADMINASSETS ?>/css/sweetalert.css" />
    <style>
        :root {
            --main-color: #212529;
            --border-color: #0f2133;
            --text-color: #abb7c4;
            --title-color: #f9ab00;
            --link-color: #f9ab00;
        }

        body {
            margin: 0;
            font-family: "Segoe UI", sans-serif;
            background-color: var(--main-color);
            color: var(--text-color);
        }

        .container {
            display: flex;
            min-height: 100vh;
            flex-wrap: wrap;
        }

        .left-panel {
            background-color: var(--main-color);
            border-right: 1px solid var(--border-color);
            flex: 1;
            min-width: 300px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 10px 20px;
            animation: slideInLeft 1s ease-in-out;
        }

        @keyframes slideInLeft {
            from {
                opacity: 0;
                transform: translateX(-40px);
            }

            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        .left-panel .icon {
            font-size: 80px;
            margin-bottom: 10px;
            color: var(--link-color);
        }

        .left-panel h1 {
            color: var(--title-color);
            margin: 0 0 10px;
            font-size: 2rem;
        }

        .left-panel p {
            font-size: 1rem;
            text-align: center;
        }

        .right-panel {
            flex: 1;
            min-width: 300px;
            padding: 10px 20px;
            display: flex;
            justify-content: center;
            align-items: center;
            background-color: #1a191f;
            
        }

        .form-box {
            width: 100%;
            max-width: 400px;
        }

        .form-box h2 {
            color: var(--title-color);
            margin-bottom: 20px;
            font-size: 1.5rem;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-group label {
            display: block;
            margin-bottom: 6px;
            color: var(--text-color);
        }

        .form-group input {
            width: 100%;
            padding: 10px;
            border: 2px solid transparent;
            border-radius: 5px;
            background-color: #222028 !important;
            color: var(--text-color);
        }

        .form-group input:focus {
            outline: none;
            border-color: var(--link-color);
        }

        .form-footer {
            margin-top: 15px;
            font-size: 0.9rem;
            color: var(--text-color);
        }

        .form-footer a {
            color: var(--link-color);
            text-decoration: none;
        }

        .form-footer a:hover {
            text-decoration: underline;
        }

        .btn-submit {
            width: 100%;
            padding: 12px;
            border: none;
            background-color: var(--link-color);
            color: #000;
            font-weight: bold;
            border-radius: 5px;
            cursor: pointer;
            transition: 0.3s ease;
        }

        .btn-submit:hover {
            background-color: #f8bf41;
        }

        input {
            background-color: #101d2b !important;
            color: var(--text-color) !important;
            border: 2px solid var(--border-color);
        }

        input:-webkit-autofill,
        input:-webkit-autofill:hover,
        input:-webkit-autofill:focus {
            -webkit-box-shadow: 0 0 0px 1000px #101d2b inset !important;
            -webkit-text-fill-color: var(--text-color) !important;
            transition: background-color 5000s ease-in-out 0s;
        }

        @media (max-width: 768px) {
            .container {
                flex-direction: column;
            }

            .left-panel {
                border-right: none;
                border-bottom: 1px solid var(--border-color);
            }
        }
    </style>
</head>

<body>

    <div class="container">
        <div class="left-panel">
            <div class="icon"><i class="fas fa-key"></i></div>
            <h1><?php echo APP_NAME; ?></h1>
            <p><?php echo APP_DESC; ?></p>
        </div>

        <div class="right-panel">
            <form class="form-box auth">
                <h2>Forgot Your Password</h2>
                <div class="form-group">
                    <label for="email">Email Address</label>
                    <input name="email" type="email" id="email" required />
                </div>
                <button type="submit" class="btn-submit">Submit</button>
                <input type="hidden" name="action" value="forgot">
                <div class="form-footer">
                    Don't have an account? <a href="<?php echo APP_URL . '/signup'; ?>">Register here</a>
                </div>
            </form>
        </div>
    </div>
    <script src="<?= MAIN_ASSETS ?>/js/jquery.js"></script>
    <script src="<?= ADMINASSETS ?>/js/sweetalert.js"></script>

    <!-- Site Scripts -->
    <script src="<?= MAIN_ASSETS ?>/main.js"></script>
</body>

</html>