<?php

$cls = isset($cts) ? $cts : 4;

foreach ($files as $file): ?>
  <?php

  $image = empty($file['image']) ? APP_URL . '/Public/assets/main/img/noimg.jpg' : APP_URL . '/Public/thumb/182x268' . $file['img_folder'] . '/' . $file['image'];
  $des0 = htmlspecialchars_decode($file['description']);
  $desc =  preg_replace('/<\/?p>/', '', $des0);
  $desc3 =  substr(htmlspecialchars_decode($desc), 0, 136);


  if ($file['author']) {
    $authors = explode(',', $file['author']);

    $authorLinks = [];
    foreach ($authors as $art) {
      $author = $db->table('author')->search(['name'], $art)->first();

      if ($author) {
        $authorLinks[] = '<a href="' . APP_URL . '/author/' . $author['slug'] . '">' . $author['name'] . ' </a>';
      }
    }

    $author = implode(', ', $authorLinks);
  }

  if ($file['groupes']) {
    $groups = explode(',', $file['groupes']);

    $groupLinks = [];
    foreach ($groups as $grp) {
      $groupD = $db->table('`groups`')->search(['name'], $grp)->first();

      if ($groupD) {
        $groupLinks[] = '<a href="' . APP_URL . '/group/' . $groupD['slug'] . '">' . $groupD['name'] . ' </a>';
      }
    }

    $group = implode(', ', $groupLinks);
  }

  ?>

  <div class="movie-item-style-2">
    <img src="<?php echo $image; ?>" alt="<?php echo $file['name'] ?>">
    <div class="mv-item-infor">
      <h6><a href="<?php echo APP_URL . '/' . $file['slug']; ?>"><?php echo $file['name'] ?> <span> (<?php echo date('Y', strtotime($file['created_at'])); ?> ) </span></a></h6>
      <p class="rate"><i class="ion-code-download"></i><span><?php echo $file['download']; ?></span> /<?php echo $file['views']; ?></p>
      <p class="describe"><?php echo $desc3; ?>... <br><br></p>
      <br>
      <p class="run-time"> Last download: <?php echo !empty('dl_last') ? to_time_ago(strtotime($file['dl_last'] ?? '')) : 'N/A'; ?> . <span>Size: <?php echo formatSize($file['size']); ?> </span> . <span>Release: <?php echo date('d D m, Y', strtotime($file['created_at'])); ?></span></p>
      <p>Author: <?php echo $author; ?> </p>
      <p>Association: <?php echo isset($groups) ? $group : ''; ?></p>
    </div>
  </div>




<?php endforeach; ?>