<div class="tab-pane fade <?php echo $section == 3 ? 'show active' : ''; ?>" id="tab-3" role="tabpanel" aria-labelledby="3-tab" tabindex="0">
	<div class="row">
		<!-- notifications section -->
		<div class="col-12">
			<div class="dashbox">
				<div class="dashbox__title">
					<h3><i class="ti ti-bell"></i> Notifications</h3>
					<div class="dashbox__wrap">
						<span class="dashbox__more"><?php echo count($notifications); ?> Total</span>
					</div>
				</div>

				<?php if (count($notifications) > 0): ?>
					<div class="dashbox__list-wrap">
						<?php foreach ($notifications as $item): ?>
							<!-- notification item -->
							<div class="notification-item">
								<div class="notification-item__icon">
									<?php
                                    // Determine icon based on notification type or content
                                    $icon = 'ti-bell';
                                    if (stripos($item['title'], 'subscription') !== false || stripos($item['message'], 'subscription') !== false) {
                                        $icon = 'ti-credit-card';
                                    } elseif (stripos($item['title'], 'download') !== false || stripos($item['message'], 'download') !== false) {
                                        $icon = 'ti-download';
                                    } elseif (stripos($item['title'], 'comment') !== false || stripos($item['message'], 'comment') !== false) {
                                        $icon = 'ti-message-circle';
                                    } elseif (stripos($item['title'], 'new') !== false || stripos($item['message'], 'new') !== false) {
                                        $icon = 'ti-sparkles';
                                    }
                                    ?>
									<i class="ti <?php echo $icon; ?>"></i>
								</div>
								<div class="notification-item__content">
									<h4 class="notification-item__title"><?php echo htmlspecialchars($item['title']); ?></h4>
									<p class="notification-item__text"><?php echo $item['message']; ?></p>
									<span class="notification-item__time">
										<i class="ti ti-clock"></i>
										<?php echo to_time_ago(strtotime($item['created_at'])); ?>
									</span>
								</div>
							</div>
							<!-- end notification item -->
						<?php endforeach; ?>
					</div>
				<?php else: ?>
					<!-- empty state -->
					<div class="dashbox__empty">
						<i class="ti ti-bell-off"></i>
						<p>No notifications yet</p>
						<span>You'll see notifications here when you have updates</span>
					</div>
					<!-- end empty state -->
				<?php endif; ?>
			</div>
		</div>
		<!-- end notifications section -->
	</div>

	<?php if (count($notifications) > 0 && $totalpages > 1): ?>
		<div class="row">
			<?php include (__DIR__ . '/../pagination.php'); ?>
		</div>
	<?php endif; ?>
</div>

<style>
/* Notification Item Styles */
.notification-item {
	display: flex;
	align-items: flex-start;
	padding: 20px;
	background-color: #222028;
	border-radius: 8px;
	margin-bottom: 15px;
	transition: all 0.3s ease;
	border-left: 3px solid transparent;
}

.notification-item:hover {
	background-color: #2b2a31;
	border-left-color: #f9ab00;
	transform: translateX(3px);
}

.notification-item__icon {
	flex-shrink: 0;
	width: 50px;
	height: 50px;
	display: flex;
	align-items: center;
	justify-content: center;
	background: rgba(249, 171, 0, 0.1);
	border-radius: 50%;
	margin-right: 20px;
}

.notification-item__icon i {
	font-size: 24px;
	color: #f9ab00;
}

.notification-item__content {
	flex: 1;
}

.notification-item__title {
	font-size: 16px;
	font-weight: 600;
	color: #fff;
	margin: 0 0 8px 0;
	line-height: 1.4;
}

.notification-item__text {
	font-size: 14px;
	color: #c0c0c0;
	margin: 0 0 10px 0;
	line-height: 1.6;
}

.notification-item__time {
	display: inline-flex;
	align-items: center;
	font-size: 13px;
	color: #808080;
}

.notification-item__time i {
	font-size: 14px;
	margin-right: 5px;
}

/* Empty State */
.dashbox__empty {
	text-align: center;
	padding: 60px 20px;
}

.dashbox__empty i {
	font-size: 64px;
	color: #3d3d3d;
	margin-bottom: 20px;
	display: block;
}

.dashbox__empty p {
	font-size: 18px;
	font-weight: 600;
	color: #fff;
	margin: 0 0 10px 0;
}

.dashbox__empty span {
	font-size: 14px;
	color: #808080;
}

/* List Wrap */
.dashbox__list-wrap {
	padding: 20px;
}

/* Responsive */
@media (max-width: 576px) {
	.notification-item {
		padding: 15px;
	}

	.notification-item__icon {
		width: 40px;
		height: 40px;
		margin-right: 15px;
	}

	.notification-item__icon i {
		font-size: 20px;
	}

	.notification-item__title {
		font-size: 15px;
	}

	.notification-item__text {
		font-size: 13px;
	}
}
</style>