<style>

        .filters {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        .filters select, .filters input {
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        .filters button {
            padding: 10px 20px;
            border: none;
            background-color: #007bff;
            color: white;
            border-radius: 5px;
            cursor: pointer;
        }
        .filters button:hover {
            background-color: #0056b3;
        }

    </style>
    
    
<div class="container-xxl flex-grow-1 container-p-y">

    <h4 class="py-3 mb-4"><span class="text-muted fw-light"><a href="<?=AdminURL?>">Home</a> </span> </h4>
 <div class="header">
            <h1>Google Analytics Dashboard</h1>
        </div>
        <div class="filters">
            <div>
                <label for="date-filter">Date Range: </label>
                <select id="date-filter">
                    <option value="today">Today</option>
                    <option value="yesterday">Yesterday</option>
                    <option value="7days">Last 7 Days</option>
                    <option value="this-week">This Week</option>
                    <option value="this-month">This Month</option>
                    <option value="custom">Custom</option>
                </select>
                <input type="date" id="start-date" style="display: none;">
                <input type="date" id="end-date" style="display: none;">
            </div>
            <button id="apply-filters">Apply Filters</button>
        </div>
  <div class="row mb-5">
    <div class="col-sm-6 col-lg-4 mb-3">
    <div class="card card-border-shadow-primary h-100">
      <div class="card-body">
        <div class="d-flex align-items-center mb-2">
          <div class="avatar me-4">
            <span class="avatar-initial rounded bg-label-primary"><i class="mdi mdi-signal mdi-24px"></i></span>
          </div>
          <h4 id='views-count' class="mb-0">0</h4>
        </div>
        <h6 class="mb-0 fw-normal">Views </h6>
        <p class="mb-0">
          <small class="text-muted">Total Views</small>
        </p>
      </div>
    </div>
  </div>
  
  
    <div class="col-sm-6 col-lg-4 mb-3">
    <div class="card card-border-shadow-warning h-100">
      <div class="card-body">
        <div class="d-flex align-items-center mb-2">
          <div class="avatar me-4">
            <span class="avatar-initial rounded bg-label-warning"><i class="mdi mdi-face-man-profile mdi-24px"></i></span>
          </div>
          <h4 class="mb-0" id="active-users-count">0</h4>
        </div>
        <h6 class="mb-0 fw-normal">Active users</h6>
        <p class="mb-0">
         
          <small class="text-muted">Total Active Users</small>
        </p>
      </div>
    </div>
  </div>
  
    <div class="col-sm-6 col-lg-4 mb-3">
    <div class="card card-border-shadow-danger h-100">
      <div class="card-body">
        <div class="d-flex align-items-center mb-2">
          <div class="avatar me-4">
            <span class="avatar-initial rounded bg-label-danger"><i class="mdi mdi-signal-5g mdi-24px"></i></span>
          </div>
          <h4 class="mb-0" id="sessions-count">0</h4>
        </div>
        <h6 class="mb-0 fw-normal">Sessions</h6>
        <p class="mb-0">
          <small class="text-muted">Total Sessions</small>
        </p>
      </div>
    </div>
  </div>
  
  
  
  
  
   <div class="col-xl-12">
    <div class="card h-100">
      <div class="card-body row g-2">
        <div class="col-12 col-md-6 card-separator pe-0 pe-md-3">
          <div class="d-flex justify-content-between align-items-center flex-wrap mb-4">
            <h5 class="m-0 me-2">Views by Country</h5>
          </div>
          <div class="pt-2">
            <div id="countries-count" class="list-group list-group-flush">
              
            </div>
          </div>
        </div>
        
        
        <div class="col-12 col-md-6 ps-0 ps-md-3 mt-3 mt-md-2">
          <div class="d-flex justify-content-between align-items-center flex-wrap mb-4">
            <h5 class="m-0 me-2">Views by Pages</h5>
          </div>
          <div class="pt-2">
            <div class="list-group list-group-flush" id="pages-list-views">
    
            </ul>
          </div>
        </div>
      </div>
      
    </div>
  </div>
  </div>
  
      </div>
      
</div>
    

    <script>
        $(document).ready(function () {
            const apiUrl = '/SHU-Admin/analytic'; 

            // Show/hide date inputs based on selection
            $('#date-filter').change(function () {
                if ($(this).val() === 'custom') {
                    $('#start-date, #end-date').show();
                } else {
                    $('#start-date, #end-date').hide();
                }
            });

            // Fetch and display analytics data
            function fetchAnalyticsData(filters) {
                $.ajax({
                    url: apiUrl,
                    method: 'POST',
                    data: filters,
                    dataType: 'json',
                    success: function (response) {
                        console.log(response);
                        $('#views-count').text(response.data.pageViews);
                        $('#active-users-count').text(response.data.activeUsers);
                        $('#sessions-count').text(response.data.sessions);
                        
                        if(response.status == 'success') {
                            
                            let CountryData = response.data.viewsByCountry;
                            let ViewsPage = response.data.viewsByPage;
                
                            let countryList = $('#countries-count');
                            countryList.empty(); // Clear the existing list
                            
                            let pageList = $('#pages-list-views');
                            pageList.empty();
                        
                            CountryData.forEach((item) => {
                                countryList.append(`<div class="list-group-item list-group-item-action waves-effect">${item.country}: ${item.views}</div>`);
                            })
                            
                            ViewsPage.forEach((item) => {
                                pageList.append(`<div class="list-group-item list-group-item-action waves-effect">${item.pageTitle}: ${item.views}</div>`);
                            })
                        }
                    },
                    error: function (error,xhr) {
                        console.error('Error fetching analytics data:', error);
                        console.log(error.responseText);
                    }
                });
            }

            // Apply filters
            $('#apply-filters').click(function () {
                const filter = $('#date-filter').val();
                let filters = { filter };

                if (filter === 'custom') {
                    filters.startDate = $('#start-date').val();
                    filters.endDate = $('#end-date').val();
                }

                fetchAnalyticsData(filters);
            });

            // Initial fetch (e.g., last 7 days)
            fetchAnalyticsData({ filter: 'today' });
        });
    </script>