<?php

global $lang, $isLogin, $AuthUser;

use App\General\DB;

$setting = 0;
$title = ' Account Page ';
$db = new DB();
$isSubscribe = false;
$isNotification = false;
$isEdit = false;
$section = 1;

$userImage = $AuthUser['image'] ? APP_URL . '/Public/thumb/users/' . $AuthUser['image'] : APP_URL . '/Public/assets/mt/hf/img/user.svg';

$plan = $db
    ->table('subscriptions s')
    ->leftJoin('packages p', 's.package_id', '=', 'p.id')
    ->where('s.user_id', $AuthUser['id'])
    ->where('s.status', 1)
    ->select(['s.*', 'p.package_name', 'p.price as package_price', 'p.days as package_duration'])
    ->first();

if (isset($_GET['shu']) && $_GET['shu'] === 'subscribe') {
    $isSubscribe = true;
    $packages = $db->table('packages')->where('status', 1)->get();
    $title = 'Subscribe |';
    $section = 2;
} else if (isset($_GET['shu']) && $_GET['shu'] === 'notification') {
    $page = isset($_GET['page']) ? $_GET['page'] : 1;
    $limit = 10;
    $offset = ($page - 1) * $limit;
    $title = 'Notifications |';
    $isNotification = true;
    $notifications = $db->table('notifications')->where('user_id', $AuthUser['id'])->where('status', 1)->orderBy('id', 'DESC')->limit($limit)->offset($offset)->get();

    $totalFiles = $db->table('notifications')->where('user_id', $AuthUser['id'])->where('status', 1)->count();
    $totalpages = ceil($totalFiles / $limit);

    if (isset($_GET['page'])) {
        $title = 'Page ' . Input('page') . ' of ' . $totalpages . ' | ' . $title;
    }

    $db->table('notifications')->where('is_read', 0)->where('user_id', $AuthUser['id'])->update(['is_read' => 1]);
    $section = 3;
} else if (isset($_GET['shu']) && $_GET['shu'] === 'edit') {
    $title = 'Edit Profile |';
    $isEdit = true;
    $section = 4;
}

if ($section === 1) {
    $totalnovelsread = $db->table('reading_history')->where('user_id', $AuthUser['id'])->count();
    $totalnovelsdownload = $db->table('download_history')->where('user_id', $AuthUser['id'])->count();
    $totalcomments = (int) $db->table('reviews')->where('user_id', $AuthUser['id'])->count() + (int) $db->table('comments')->where('email', $AuthUser['email'])->count();

    $limit = 20;
    $cPage = 1;
    $page = Input('page') ? Input('page') : 1;
    $offset = ($page - 1) * $limit;

    $totalFiles = $db
        ->table('reading_history as rh')
        ->leftJoin('ebook as e', 'rh.novel_id', '=', 'e.id')
        ->where('rh.user_id', $AuthUser['id'])
        ->where('e.status', 1)
        ->count();

    $totalpages = ceil($totalFiles / $limit);

    $lastRead = $db
        ->table('reading_history as rh')
        ->leftJoin('ebook as e', 'rh.novel_id', '=', 'e.id')
        ->leftJoin('category as c', 'e.cid', '=', 'c.id')
        ->where('rh.user_id', $AuthUser['id'])
        ->where('e.status', 1)
        ->orderBy('rh.updated_at', 'DESC')
        ->select(['rh.*', 'e.name', 'e.slug', 'e.author', 'c.name as cat_name', 'c.slug as cat_slug', 'e.id e_id'])
        ->offset($offset)
        ->limit($limit)
        ->get();

    $lastDownload = $db
        ->table('download_history as dh')
        ->leftJoin('ebook as e', 'dh.novel_id', '=', 'e.id')
        ->leftJoin('category as c', 'e.cid', '=', 'c.id')
        ->where('dh.user_id', $AuthUser['id'])
        ->where('e.status', 1)
        ->orderBy('dh.updated_at', 'DESC')
        ->select(['dh.*', 'e.name', 'e.slug', 'e.author', 'c.name as cat_name', 'c.slug as cat_slug', 'e.id e_id'])
        ->offset($offset)
        ->limit($limit)
        ->get();
}
