<?php
use App\General\Admin\Analytics;


if($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
    
    $filter = $_POST['filter'] ?? '';
    $startDate = $_POST['startDate'] ?? 'today';
    $endDate = $_POST['endDate'] ?? 'today';
    
    try {
        
     $analytics = new Analytics();
    $propertyId = '474635152';
    
    
    switch ($filter) {
        case 'today':
            $startDate = $endDate = date('Y-m-d');
            break;
        case 'yesterday':
            $startDate = $endDate = date('Y-m-d', strtotime('-1 day'));
            break;
        case '7days':
            $startDate = date('Y-m-d', strtotime('-7 days'));
            $endDate = date('Y-m-d');
            break;
        case 'this-week':
            $startDate = date('Y-m-d', strtotime('last Sunday'));
            $endDate = date('Y-m-d');
            break;
        case 'this-month':
            $startDate = date('Y-m-01');
            $endDate = date('Y-m-d');
            break;
        case 'custom':
            if (!$startDate || !$endDate) {
                throw new Exception('Custom date range requires both startDate and endDate.');
            }
            break;
        default:
            throw new Exception('Invalid date filter.');
    }


        
       $response = $analytics->getData($propertyId, $startDate, $endDate); 
       $response2 = $analytics->getViewsByPage($propertyId, $startDate, $endDate);
       $response3 = $analytics->getViewsByCountry($propertyId, $startDate, $endDate);
    
    
    

    
    
    $data = [
    'pageViews' => 0,
    'activeUsers' => 0,
    'sessions' => 0,
    'activeUsersByCountry' => [],
    'viewsByPage' => [],
    'viewsByCountry' => [],
];

    foreach ($response->getRows() as $row) {
    $data['pageViews'] += $row->getMetricValues()[2]->getValue(); // screenPageViews
    $data['activeUsers'] += $row->getMetricValues()[0]->getValue();
    $data['sessions'] += $row->getMetricValues()[1]->getValue();

    // Country-based data
    $country = $row->getDimensionValues()[1]->getValue(); // Country name
    $data['activeUsersByCountry'][$country] = 
        ($data['activeUsersByCountry'][$country] ?? 0) + $row->getMetricValues()[0]->getValue();
}

    $data['viewsByPage'] = $response2;
    $data['viewsByCountry'] = $response3;

    // Return the JSON response
    echo json_encode(['status' => 'success', 'data' => $data]);
    } catch(Exception $e) {
        
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    
    
} else {
    
    $title = "Google Analytics";
}
        
